/*
 * Decompiled with CFR 0.152.
 */
package mjs.processing.mobile.mvideo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.RecordControl;
import mjs.processing.mobile.mvideo.MBuffer;
import mjs.processing.mobile.mvideo.MMovie;
import mjs.processing.mobile.mvideo.MVideo;
import processing.core.PMIDlet;

public class MVideoRecorder
extends MVideo {
    private MBuffer output;
    private String locator;
    private RecordControl recordControl;

    public MVideoRecorder(PMIDlet pMIDlet, String parameters) {
        super(pMIDlet, "capture://audio_video" + parameters);
        this.recordControl = (RecordControl)this.player.getControl("RecordControl");
        if (this.recordControl == null) {
            throw new RuntimeException("Video Recorder Not Supported");
        }
    }

    public MVideoRecorder(PMIDlet pMIDlet) {
        this(pMIDlet, "");
    }

    public void startRecord() {
        new Thread(){

            public void run() {
                try {
                    if (MVideoRecorder.this.recordControl != null) {
                        if (MVideoRecorder.this.locator == null) {
                            if (MVideoRecorder.this.output == null) {
                                MVideoRecorder.this.output = new MBuffer(MVideoRecorder.this.pMIDlet);
                                MVideoRecorder.this.recordControl.setRecordStream((OutputStream)MVideoRecorder.this.output);
                            } else {
                                MVideoRecorder.this.output.reset();
                            }
                        }
                        MVideoRecorder.this.recordControl.startRecord();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }.start();
    }

    public void stopRecord() {
        try {
            this.recordControl.stopRecord();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public MVideo video() {
        if (this.recordControl == null) {
            return null;
        }
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(this.read());
            Player videoPlayer = Manager.createPlayer((InputStream)input, (String)this.recordControl.getContentType());
            return new MMovie(this.pMIDlet, videoPlayer);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public MMovie movie() {
        return (MMovie)this.video();
    }

    public byte[] read() {
        if (this.recordControl == null) {
            return null;
        }
        try {
            this.recordControl.commit();
            return this.output.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public int setRecordSizeLimit(int size) {
        try {
            if (this.recordControl != null) {
                return this.recordControl.setRecordSizeLimit(size);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return -1;
    }

    public String contentType() {
        return this.recordControl.getContentType();
    }

    public void setLocation(String locator) {
        try {
            this.locator = locator;
            if (this.recordControl != null) {
                this.recordControl.setRecordLocation(locator);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public void save() {
        try {
            this.recordControl.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

